<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ConfrontoImmagini {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $immagine1;
        private $immagine2;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $immagine1="", $immagine2="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome           = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->immagine1      = $immagine1;
            $this->immagine2      = $immagine2;
        }

        function crea() {
            $query ="INSERT INTO geec_confrontoImmagini VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->immagine1','$this->immagine2')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_confrontoImmagini SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', immagine1='$this->immagine1', immagine2='$this->immagine2' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function cambiaImmagine1($immagine1) {
            $query    = "UPDATE geec_confrontoImmagini SET immagine1='$immagine1' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function cambiaImmagine2($immagine2) {
            $query    = "UPDATE geec_confrontoImmagini SET immagine2='$immagine2' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_confrontoImmagini",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 28
            eliminaOccorrenzeComponente($this->db,$this->id,28);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_confrontoImmagini VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiInvitoAzione   = $this->db->leggiSingolaRiga("geec_confrontoImmagini",$this->id);
            $this->nome = $datiInvitoAzione["nome"];
            $this->spazioOccupato   = $datiInvitoAzione["spazioOccupato"];
            $this->immagine1        = $datiInvitoAzione["immagine1"];
            $this->immagine2        = $datiInvitoAzione["immagine2"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getImmagine1() {
            return $this->immagine1;
        }

        public function getImmagine2() {
            return $this->immagine2;
        }

        public function getAltezza() {
            return $this->altezza;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setImmagine1($immagine1) {
            $this->immagine1 = $immagine1;
        }

        public function setImmagine2($immagine2) {
            $this->immagine2 = $immagine2;
        }

        public function setAltezza($altezza) {
            $this->altezza = $altezza;
        }
        
    }